<section class="search-2">
    <div class="container">
        <div class="row">
            <div class="col-lg-10">
                <div class="search-container">
                    <div class="bg-layer"
                        style="background: url({{asset('frontend/images/shape/search.webp')}});">
                    </div>
                    <div class="search-form">

                        <form action="#/packages" method="GET">
                            <div class="serach-title">
                                <h6><i class="fa-light fa-earth-americas"></i> Explore the globe with</h6>
                            </div>
                            <div class="search-form-inner">
                                <div class="location search-box">
                                    <i class="fa-light fa-location-dot"></i>
                                    <div class="select-option">
                                        <input class="form-control" type="text" name="search"
                                            placeholder="e.g. Dubai" />
                                    </div>
                                    <ul class="options">
                                        <div class="search-result" id="searchResults"></div>
                                    </ul>
                                </div>
                                <div class="date">
                                    <input class="flatpickr" name="date" id="myID" type="text"
                                        placeholder="Select Date" />
                                    <i class="fa-thin fa-calendar-days"></i>
                                </div>
                                <div class="count">
                                    <div class="count-counter">
                                        <i class="fa-light fa-user"></i>
                                        <div class="count-counter-inner">
                                            <span class="adult">0</span>
                                            <p>adult</p>
                                        </div>
                                        <div class="count-counter-inner">
                                            <span class="children">0</span>
                                            <p>children</p>
                                        </div>
                                        <div class="count-counter-inner">
                                            <span class="infant">0</span>
                                            <p>infant</p>
                                        </div>
                                    </div>
                                    <div class="count-container">
                                        <div class="count-single">
                                            <div class="count-single-text">
                                                <h6>Adult</h6>
                                                <p>Over 12 Years</p>
                                            </div>
                                            <div class="count-single-inner">
                                                <button type="button" class="decrement" data-type="adult">-</button>
                                                <span class="adult">0</span>
                                                <button type="button" class="increment" data-type="adult">+</button>
                                            </div>
                                        </div>
                                        <div class="count-single">
                                            <div class="count-single-text">
                                                <h6>Children</h6>
                                                <p>Below 12 Years</p>
                                            </div>
                                            <div class="count-single-inner">
                                                <button type="button" class="decrementTwo"
                                                    data-type="children">-</button>
                                                <span class="children">0</span>
                                                <button type="button" class="incrementTwo"
                                                    data-type="children">+</button>
                                            </div>
                                        </div>
                                        <div class="count-single">
                                            <div class="count-single-text">
                                                <h6>Infant</h6>
                                                <p>Below 3 Years</p>
                                            </div>
                                            <div class="count-single-inner">
                                                <button type="button" class="decrementThree"
                                                    data-type="infant">-</button>
                                                <span class="infant">0</span>
                                                <button type="button" class="incrementThree"
                                                    data-type="infant">+</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="btn-1"><i class="fa-light fa-magnifying-glass"></i>
                                    <span></span></button>
                            </div>
                            <input type="hidden" name="adults" id="adultInput" value="0">
                            <input type="hidden" name="children" id="childrenInput" value="0">
                            <input type="hidden" name="infants" id="infantInput" value="0">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@push('script')
<script>
    document.querySelectorAll('.increment, .decrement, .incrementTwo, .decrementTwo, .incrementThree, .decrementThree').forEach(button => {
            button.addEventListener('click', () => {
                const type = button.getAttribute('data-type');
                const delta = button.classList.contains('increment') || button.classList.contains('incrementTwo') || button.classList.contains('incrementThree') ? 1 : -1;
                updateCount(type, delta);
            });
        });


        function updateCount(type, delta) {
            const spans = document.querySelectorAll(`.${type}`);
            let count = parseInt(spans[0].textContent);
            count = Math.max(0, count + delta);

            spans.forEach(span => {
                span.textContent = count;
            });

            document.getElementById(type + 'Input').value = count;
        }
</script>
@endpush
